// Extend Sphere //

/* ==Extend the Object object== */

// Utilizes json2 and Sphere file object to save and load object member data //
/** @param exclude, an array that excludes certain properties in the object */
Object.prototype.save = function(file, key, exclude)
{
	if (exclude === undefined) exclude = [];
	var SaveMe = {};
	for (var i in this)
	{
		// don't want to save the functions.
		if (typeof this[i] != 'function' && !exclude.contains(i)) SaveMe[i] = this[i];
	}
	var SaveString = JSON.stringify(SaveMe);
	file.write(key, SaveString);
	file.flush();
}

Object.prototype.load = function(file, key)
{
	var LoadString = file.read(key, "null");
	var LoadMe = JSON.parse(LoadString);
	for (var i in LoadMe) this[i] = LoadMe[i];
}

// returns a copy of this instance //
Object.prototype.clone = function ()
{
	var temp = {};
	for (var i in this) temp[i] = this[i];
	return temp;
}

// returns the amount of properties in this instance //
Object.prototype.getLength = function()
{
	var j = 0;
	for (var i in this)
	{
		if (typeof this[i] != 'function') j++;
	}
	return j;
}

// returns a numerical array with properties akin to the object instance //
Object.prototype.toArray = function()
{
	var temp = [];
	for (var i in this)
	{
		if (typeof this[i] != 'function') temp.push(this[i]);
	}
	return temp;
}

// clears all of the properties from this instance //
Object.prototype.clear = function()
{
	for (var i in this) this[i] = null;
}

/* ==Extend the Array object== */
// Note: Most prototyping occurs above because arrays are objects.

// returns the array index of a certain value //
Array.prototype.indexOf = function(value)
{
	var i = this.length
	while(i--) { if (this[i] == value) return i; }
	return -1;
}

// returns a random index value //
Array.prototype.getRandom = function()
{
	var num = Math.floor(Math.random()*this.length);
	return this[num];
}

// returns true if this array contains a certain value //
Array.prototype.contains = function(value)
{
	var i = this.length;
	while(i--) { if (this[i] == value) return true; }
	return false;
}

// This will save an array, notice it has index values //
Array.prototype.save = function(file, key)
{
	var SaveArray = [];
	for (var i = 0; i < this.length; ++i) SaveArray[i] = this[i];
	var SaveString = JSON.stringify(SaveArray);
	file.write(key, SaveString);
	file.flush();
}

// this will load an array, notice it's max index size //
Array.prototype.load = function(file, key)
{
	var LoadString = file.read(key, "null");
	var tempArray = JSON.parse(LoadString);
	for (var i in tempArray) this[i] = tempArray[i];
}

Array.prototype.swap = function(a, b)
{
	
	var temp = this[a];
	this[a] = this[b];
	this[b] = temp; 
}

/* ==Extend the String object== */

// returns true if the string ends with a: . or ! or ?.
String.prototype.hasEnding = function()
{
	var temp = this[this.length-1];
	if (temp == "." || temp == "!" || temp == "?") return true;
	else return false;
}

// returns the string minus the ending if it has one //
String.prototype.minusEnd = function()
{
	if (this.hasEnding()) return this.substr(0, this.length-1);
	else return this;
}

String.prototype.getNumChar = function(character)
{
	var num = 0;
	for (var i = 0; i < this.length; ++i)
	{
		if (this.charAt(i) == character) num++;
	}
	return num;
}

/* == Extend the Math object */
/*
Math.prototype.degToRad = function(deg)
{
	return (deg * this.PI / 180.0);
}

Math.prototype.radToDeg = function(rad)
{
	return (rad * 180.0 / this.PI);
}
*/
/* == Extend the Boolean object== */

// returns the opposite value of this particular boolean //
Boolean.prototype.reverse = function()
{
	return (this == false);
}

/*
function game()
{
	var hi = {prop1: true, prop2: ["hi", ["what", "now"], 6], prop3: 56, prop4: "what?", prop5: {cool: 9}, prop6: 8};
	var myArray = hi.toArray();
	Abort(hi.toString());
}*/